IF OBJECT_ID('UFD_CONSULTA_BLOQUEIO_PENDENTE') IS NOT NULL
	BEGIN
		DROP FUNCTION UFD_CONSULTA_BLOQUEIO_PENDENTE
	END
	
GO
 
CREATE FUNCTION [DBO].[UFD_CONSULTA_BLOQUEIO_PENDENTE] (@LISTA_CD_CTR VARCHAR(MAX))     
RETURNS @RS_BLOQ TABLE
(
	CD_CTR  INT,
	TP_BLOQ INT,
	CD_PED  INT
)

AS
BEGIN
	DECLARE @FLAG_DESATIVAR_DIVERG_COND_PGTO_PEDIDO INT,@FLAG_DESATIVAR_DIVERG_VALOR_PGTO_PEDIDO TINYINT;

	SET @FLAG_DESATIVAR_DIVERG_COND_PGTO_PEDIDO =ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG WHERE CD_CHAVE = 'FLAG_DESATIVAR_DIVERG_COND_PGTO_PEDIDO'),0);
	SET @FLAG_DESATIVAR_DIVERG_VALOR_PGTO_PEDIDO =ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG WHERE CD_CHAVE = 'FLAG_DESATIVAR_DIVERG_VALOR_PGTO_PEDIDO'),0);

	DECLARE @VLR_DIV MONEY =ISNULL((SELECT replace(VALOR, ',', '.' ) FROM PRC_EMP_CONFIG
											 WHERE
												CD_CHAVE = 'VLR_MAX_DIVERGENCIA_DANFE_X_PEDIDO'), 0.02);

	DECLARE @RS_DANFE TABLE 
	(
		CD_CTR_DANFE INT,
		FLAG_IGNORAR_GERA_FINAN INT
	);

	DECLARE @RS_DANFE_LIB TABLE 
	(
		CD_CTR  INT,
		TP_BLOQ INT
	);

	DECLARE @RS_ENT TABLE
	(
			CD_EMP         INT,
			CD_CTR_DANFE   INT,
			CD_FILIAL      INT,
			CD_FORN        INT,
			CD_PED_FORN    VARCHAR(30),
			NR_NF          INT,
			CD_PED         INT,
			CD_COND_PGTO   INT,
			VLR_NF         MONEY,
			VLR_PED        MONEY,
			VLR_DESC       MONEY,
			VLR_DESC_FINAN MONEY,
			DT_FATURAMENTO DATE,
			BONIFICACAO    TINYINT,
			VLR_IMPOSTO	 MONEY,
			FLAG_IGNORAR_GERA_FINAN INT
	);

	DECLARE @RS_ENT_IT TABLE
	(
		CD_EMP            INT,
		CD_FILIAL         INT,
		CD_CTR_DANFE      INT,
		CD_PED            INT,
		CD_PROD           INT,
		QT_IT_PED         MONEY,
		VLR_IT_PED        MONEY,
		VLR_DESC_PED      MONEY,
		VLR_IT_DESC_PED   MONEY,
		QT_IT_DANFE       MONEY,
		VLR_IT_DANFE      MONEY,
		VLR_DESC_DANFE    MONEY,
		VLR_IT_DESC_DANFE MONEY,
		QT_SALDO		   MONEY
	);

	INSERT INTO @RS_DANFE
	SELECT
		d.CD_CTR
		,ISNULL(P.FLAG_IGNORAR_GERA_FINAN,0)
	FROM
		EST_NF_ENT_DANFE_PROVISORIO D
		INNER JOIN (select ID AS CD_CTR from UFD_PRM_IN_STRING_string(@LISTA_CD_CTR)) F ON
			d.CD_CTR = F.CD_CTR
		INNER JOIN PG_FORN P ON
			D.CD_EMP = P.CD_EMP AND
			D.CD_FORN = P.CD_FORN
	WHERE FLAG_LIBERA_ENTRADA_SEM_PEDIDO <> 1
	
	INSERT INTO @RS_DANFE_LIB
	SELECT
		D.CD_CTR_DANFE
		,B.TIPO_BLQ
	FROM
		@RS_DANFE D
		INNER JOIN EST_NF_ENT_DANFE_PROVISORIO_LIBERACAO_TIPO_BLQ B ON
			D.CD_CTR_DANFE = B.CD_CTR

	INSERT INTO @RS_ENT (CD_EMP,
								 CD_CTR_DANFE,
								 CD_FILIAL,
								 CD_FORN,
								 CD_PED_FORN,
								 NR_NF,
								 CD_PED,
								 CD_COND_PGTO,
								 VLR_NF,
								 VLR_PED,
								 VLR_DESC,
								 VLR_DESC_FINAN,
								 DT_FATURAMENTO,
								 BONIFICACAO,
								 VLR_IMPOSTO,
								 FLAG_IGNORAR_GERA_FINAN)
	SELECT
		D.CD_EMP
		,D.CD_CTR
		,D.CD_FILIAL
		,D.CD_FORN
		,D.CD_PED_FORN
		,D.NR_NF
		,P.CD_PED
		,P.CD_COND_PGTO
		,( d.VLR_PROD_TOT - d.VLR_DESCONTO )
		,p.VLR_TOT_PROD
		,P.VLR_DESC
		,0 VLR_DESC_FINAN
		,D.DT_EMIS_NF DT_FAT
		,CASE WHEN TP_MOV IN( 3, 4, 5 ) THEN 1
			ELSE 0
			END                                BONIFICA
		,ISNULL(D.VLR_ICMS_SUBS,0) VLR_IMPOSTO
		,FLAG_IGNORAR_GERA_FINAN
	FROM
		EST_NF_ENT_DANFE_PROVISORIO D
		INNER JOIN @RS_DANFE Y ON
			D.CD_CTR = Y.CD_CTR_DANFE
		INNER JOIN EST_NF_ENT_DANFE_PROVISORIO_EST_PED_CP DP ON
			D.CD_CTR = DP.CD_CTR
		INNER JOIN EST_PED_CP P ON
			DP.CD_EMP = P.CD_EMP AND
			DP.CD_FILIAL = P.CD_FILIAL AND
			DP.CD_PED = P.CD_PED
		JOIN GLB_MOV_OP O ON
			P.CD_NT_MOV = O.CD_MOV_OP
	WHERE
		D.CD_EMP = 1;

	/***************************************************************************************************************************************/
		-- DANFE SEM PEDIDO 
	/***************************************************************************************************************************************/
	--PRINT 'Danfe sem pedido  '
	--				+ CONVERT(VARCHAR, GETDATE(), 108);

	INSERT INTO @RS_BLOQ
		(CD_CTR,
		TP_BLOQ,
		CD_PED)
	SELECT
		D.CD_CTR CD_CTR_DANFE
		,3
		,0 CD_PED
	FROM
		EST_NF_ENT_DANFE_PROVISORIO D
		INNER JOIN PG_FORN F ON
			D.CD_EMP = F.CD_EMP AND
			D.CD_FORN = F.CD_FORN AND
			F.FLAG_ENTRAR_NF_SEM_VINC_PEDIDO = 0 --QUE NAO PERMITE ENTRADA SEM PEDIDO.
		INNER JOIN @RS_DANFE Y ON
			D.CD_CTR = Y.CD_CTR_DANFE
		LEFT JOIN EST_NF_ENT_DANFE_PROVISORIO_EST_PED_CP DP ON
			D.CD_CTR = DP.CD_CTR
		LEFT JOIN @RS_DANFE_LIB L ON
			D.CD_CTR = L.CD_CTR AND
			L.TP_BLOQ = 3
	WHERE
		DP.CD_CTR IS NULL AND
		L.CD_CTR IS NULL --> QUE NAO ESTEJA LIBERADO..
		AND D.FLAG_LIBERA_ENTRADA_SEM_PEDIDO = 0;

/***************************************************************************************************************************************/
/***************************************************************************************************************************************/
/***************************************************************************************************************************************/


/***************************************************************************************************************************************/
/***************************************************************************************************************************************/
		--EST_NF_ENT_DANFE_PROVISORIO_BLOQUEIO_PENDENTE 
		--TIPO_BLQ
		--	0 - NO ENCONTRADO
		--	1 - ENCONTRADO E OK
		--	2 - DIVERGENCIA A MAIOR
		-- 3 SEM XPED
		-- 4 CONDICOES DE PAGAMENTO
		-- 5 VALOR PAGAMENTO DIVERGENTE
		-- 6 DT VENCIMENTO INVALIDO
		-- 7 QTDE ITEM DIVERGENTE 
		-- 8 VLR ITEM DIVERGENTE
		-- 9 VLR DESC PED DIVERGENTE
/**********************************************************************************************************************************/
		-- VALIDA A CONDICAO DE PAGAMENTOS
/**********************************************************************************************************************************/

	IF @FLAG_DESATIVAR_DIVERG_COND_PGTO_PEDIDO=0
	BEGIN
		-- CONDICAO PAGTO INVALIDA
		INSERT INTO @RS_BLOQ (CD_CTR,
								 TP_BLOQ,
								 CD_PED)
		SELECT
			A.CD_CTR_DANFE
			,4 TP_BLOQ
			,A.CD_PED
		FROM
			@RS_ENT A
			LEFT JOIN GLB_COND_PGTO B ON
				A.CD_EMP = B.CD_EMP AND
				A.CD_COND_PGTO = B.CD_COND_PGTO
			LEFT JOIN @RS_DANFE_LIB L ON
				A.CD_CTR_DANFE = L.CD_CTR AND
				L.TP_BLOQ = 4
		WHERE
			B.CD_COND_PGTO IS NULL AND
			A.BONIFICACAO = 0 AND
			L.CD_CTR IS NULL
			AND A.FLAG_IGNORAR_GERA_FINAN =0; --> QUE NAO ESTEJA LIBERADO..

		-- VALOR PAGAMENTO DIVERGENTE
		--DECLARE @VLR_DIV MONEY =0.02
		if @FLAG_DESATIVAR_DIVERG_VALOR_PGTO_PEDIDO =0
		BEGIN
			INSERT INTO @RS_BLOQ
									(CD_CTR,
									 TP_BLOQ,
									 CD_PED)
			SELECT
				A.CD_CTR_DANFE
				,5 TP_BLOQ
				,A.CD_PED
			FROM
				@RS_ENT A
				LEFT JOIN @RS_DANFE_LIB L ON
					A.CD_CTR_DANFE = L.CD_CTR AND
					L.TP_BLOQ = 5
			WHERE
				(( A.VLR_NF - A.VLR_IMPOSTO)- A.VLR_PED ) > @VLR_DIV AND
				A.BONIFICACAO          = 0 
				AND L.CD_CTR IS NULL
				AND A.FLAG_IGNORAR_GERA_FINAN =0; --> QUE NAO ESTEJA LIBERADO..

  

			INSERT INTO @RS_BLOQ
									(CD_CTR,
									 TP_BLOQ,
									 CD_PED)
			SELECT
				A.CD_CTR_DANFE
				,5 TP_BLOQ
				,A.CD_PED
			FROM
				EST_NF_ENT_DANFE_PROVISORIO_DUPLICATA D
				INNER JOIN @RS_ENT A ON
					D.CD_CTR = A.CD_CTR_DANFE
				LEFT JOIN @RS_DANFE_LIB L ON
					A.CD_CTR_DANFE = L.CD_CTR AND
					L.TP_BLOQ = 5
			WHERE
				(	( ( D.VLR_TITULO-A.VLR_IMPOSTO) - A.VLR_PED )      > @VLR_DIV  OR
					( A.VLR_DESC_FINAN - D.VLR_DESC ) > @VLR_DIV 
					) AND
				A.BONIFICACAO = 0 
				AND L.CD_CTR IS NULL
				AND A.FLAG_IGNORAR_GERA_FINAN =0; --> QUE NAO ESTEJA LIBERADO..
		END

		INSERT INTO @RS_BLOQ
								(CD_CTR,
								 TP_BLOQ,
								 CD_PED)
		SELECT
			A.CD_CTR_DANFE
			,4 TP_BLOQ
			,--CONDICAO PGTO DUPLICATA
			A.CD_PED
		FROM
			@RS_ENT A
			LEFT JOIN EST_NF_ENT_DANFE_PROVISORIO_DUPLICATA D ON
				A.CD_CTR_DANFE = D.CD_CTR
			LEFT JOIN @RS_DANFE_LIB L ON
				A.CD_CTR_DANFE = L.CD_CTR AND
				L.TP_BLOQ = 4
		WHERE
			D.CD_CTR IS NULL 
			AND A.BONIFICACAO = 0 
			AND L.CD_CTR IS NULL
			AND A.FLAG_IGNORAR_GERA_FINAN =0; --> QUE NAO ESTEJA LIBERADO..
		
		--  DT VENCIMENTO INVALIDA.
		INSERT INTO @RS_BLOQ
								(CD_CTR,
								 TP_BLOQ,
								 CD_PED)
		SELECT
			A.CD_CTR_DANFE
			,6 TP_BLOQ
			,A.CD_PED
		FROM
			EST_NF_ENT_DANFE_PROVISORIO_DUPLICATA D
			INNER JOIN @RS_ENT A ON
				D.CD_CTR = A.CD_CTR_DANFE
			INNER JOIN GLB_COND_PGTO_CPL B ON
				A.CD_EMP = B.CD_EMP AND
				A.CD_COND_PGTO = B.CD_COND_PGTO AND
				( D.CD_CTR_TITULO + 1 ) = B.NR_VENCTO
			LEFT JOIN @RS_DANFE_LIB L ON
				A.CD_CTR_DANFE = L.CD_CTR AND
				L.TP_BLOQ = 6
		WHERE
			L.CD_CTR IS NULL --> QUE NAO ESTEJA LIBERADO..
			AND A.BONIFICACAO = 0 
			AND D.DT_VENCTO  < DATEADD(DAY, B.DIAS_VENCTO, DT_FATURAMENTO)
			AND A.FLAG_IGNORAR_GERA_FINAN =0;
	END	

/**********************************************************************************************************************************/
	-- VALIDA O CABECALHO DO PEDIDO.
/**********************************************************************************************************************************/
		--PRINT 'Vincula o cabealho do pedido  '
		--			+ CONVERT(VARCHAR, GETDATE(), 108);
	 
	INSERT INTO @RS_ENT_IT (CD_EMP,
								CD_FILIAL,
								CD_CTR_DANFE,
								CD_PED,
								CD_PROD,
								QT_IT_PED,
								VLR_IT_PED,
								VLR_DESC_PED,
								VLR_IT_DESC_PED,
								QT_IT_DANFE,
								VLR_IT_DANFE,
								VLR_DESC_DANFE,
								VLR_IT_DESC_DANFE,
								QT_SALDO)
	SELECT
		D.CD_EMP
		,D.CD_FILIAL
		,D.CD_CTR_DANFE
		,D.CD_PED
		,D.CD_PROD
		,ISNULL(ROUND(I.QT_IT * CASE WHEN I.QT_EMB=0 THEN 1 ELSE I.QT_EMB END - ISNULL(C.QT_PROD,0) * CASE WHEN I.QT_EMB=0 THEN 1 ELSE I.QT_EMB END, 2),0) QT_IT
		,ISNULL(ROUND(I.VLR_IT, 2),0)
		,ISNULL(ROUND(I.VLR_DESC, 2),0)
		,CASE WHEN ISNULL(I.QT_IT,0) = 0 THEN 0 ELSE ISNULL(ROUND(I.VLR_DESC / ( ROUND(I.QT_IT *  CONVERT(DECIMAL(13, 4), CASE WHEN I.QT_EMB=0 THEN 1 ELSE I.QT_EMB END), 4) ), 4),0) END
		,D.QT_IT
		,D.VLR_IT
		,D.VLR_PROD_DESC
		,ROUND(D.VLR_PROD_DESC /  D.QT_IT, 4)
		,QT_SALDO = dbo.UFD_EST_PED_CP_IT_SLD_DANFE(D.CD_EMP,D.CD_FILIAL,D.CD_PED,D.CD_PROD,1,D.CD_CTR_DANFE)
	FROM
		(SELECT
			A.CD_EMP
			,A.CD_FILIAL
			,A.CD_CTR_DANFE
			,A.CD_PED
			,D.CD_PROD
			,ROUND(AVG(( D.VLR_PROD_UNIT ) / ( CONVERT(DECIMAL(13, 4), CASE WHEN ISNULL(APRES_QT_CP,0)=0 THEN 1  ELSE APRES_QT_CP END) / 
										CONVERT(DECIMAL(13, 4), CASE WHEN APRES_EMB_CP=0 THEN 1  ELSE APRES_EMB_CP END ) )), 4) 
			-
				(	 SUM(d.VLR_ICMS_RET) / 
					ROUND(SUM(
							D.QTDE_PROD * (  CONVERT(DECIMAL(13, 4), CASE WHEN ISNULL(APRES_QT_CP,0)=0 THEN 1  ELSE APRES_QT_CP END )
														/
										CONVERT(DECIMAL(13, 4), CASE WHEN ISNULL(APRES_EMB_CP,0)=0 THEN 1  ELSE APRES_EMB_CP END ) 
										)										  
					), 
					4) 
				) AS VLR_IT--Abate Icms Retido

			,ROUND(SUM(D.QTDE_PROD * (  CONVERT(DECIMAL(13, 4),CASE WHEN ISNULL(APRES_QT_CP,0)=0 THEN 1  ELSE APRES_QT_CP END) /
									CONVERT(DECIMAL(13, 4), CASE WHEN APRES_EMB_CP=0 THEN 1  ELSE APRES_EMB_CP END ) )), 4) QT_IT
			,ROUND(SUM(D.VLR_PROD_DESC), 4) VLR_PROD_DESC
		FROM
			@RS_ENT A
			INNER JOIN EST_NF_ENT_DANFE_PROVISORIO_ITENS D ON
				A.CD_CTR_DANFE = D.CD_CTR
		WHERE
			D.QTDE_PROD>0
		GROUP  BY
			A.CD_EMP
			,A.CD_FILIAL
			,A.CD_CTR_DANFE
			,A.CD_PED
			,D.CD_PROD) D 
	LEFT OUTER JOIN EST_PED_CP_IT I ON
		I.CD_EMP = D.CD_EMP AND
		I.CD_FILIAL = D.CD_FILIAL AND
		I.CD_PED = D.CD_PED AND
		I.CD_PROD = D.CD_PROD
	LEFT OUTER JOIN (
		SELECT CD_EMP, CD_FILIAL, CD_PED, CD_PROD, SUM(QT_PROD) AS QT_PROD
		FROM EST_PED_CP_IT_CANCEL_SLD 
		GROUP BY CD_EMP, CD_FILIAL, CD_PED, CD_PROD
	) AS C ON
			I.CD_EMP = C.CD_EMP AND
			I.CD_FILIAL = C.CD_FILIAL AND
			I.CD_PED = C.CD_PED AND
			I.CD_PROD = C.CD_PROD
	--WHERE
	--	-- I.QT_IT     > 0 AND
	--	D.CD_EMP    = 1 AND
	--	D.CD_FILIAL = @CD_FILIAL -- CDIGO ORIGINAL NA PROCEDURE TINHA ESTE "WHERE". RETIRADO POIS NO VI NECESSIDADE J QUE AS NOTAS FISCAIS FORAM PASSADAS COMO PARMETRO E GRAVADAS EM TAB. TEMPORRIA.

			 
	-- QTDE ITEM DIVERGENTE
	INSERT INTO @RS_BLOQ(CD_CTR,
								TP_BLOQ,
								CD_PED)
	SELECT DISTINCT
		A.CD_CTR_DANFE
		,7
		,A.CD_PED
	FROM
		@RS_ENT_IT A
		LEFT JOIN @RS_DANFE_LIB L ON
			A.CD_CTR_DANFE = L.CD_CTR AND
			L.TP_BLOQ = 7
	WHERE
		(QT_IT_DANFE > QT_IT_PED OR QT_IT_DANFE > QT_SALDO) AND
		L.CD_CTR IS NULL; --> QUE NAO ESTEJA LIBERADO..
			
			
	INSERT INTO @RS_BLOQ (CD_CTR,  TP_BLOQ, CD_PED)
	SELECT
		A.CD_CTR
		,7
		,A.CD_PED
	FROM
		(SELECT
				A.CD_CTR
				,E.CD_PED
				,COUNT(DISTINCT CD_PROD) QT_SKU_DANFE
			FROM
				EST_NF_ENT_DANFE_PROVISORIO_ITENS A
				JOIN @RS_ENT E ON
					A.CD_CTR = E.CD_CTR_DANFE
			GROUP  BY
			A.CD_CTR,E.CD_PED) a
		JOIN (SELECT
					e.CD_CTR_DANFE CD_CTR
					,A.CD_PED
					,COUNT(*)      QT_SKU_PED
				FROM
					EST_PED_CP_IT A
					JOIN @RS_ENT E ON
					A.CD_EMP = E.CD_EMP AND
					A.CD_PED = E.CD_PED AND
					A.CD_FILIAL = E.CD_FILIAL
				GROUP  BY
					e.CD_CTR_DANFE, A.CD_PED) b ON
		A.CD_CTR = B.CD_CTR AND
		A.QT_SKU_DANFE > B.QT_SKU_PED;

/**********************************************************************************************/
/**********************************************************************************************/
	--  VLR ITEM DIVERGENTE 
	--DECLARE @VLR_DIV MONEY =0.02
	INSERT INTO @RS_BLOQ
							(CD_CTR,
								TP_BLOQ,
								CD_PED)
	SELECT DISTINCT
		A.CD_CTR_DANFE
		,8
		,A.CD_PED
	FROM
		@RS_ENT_IT A
		LEFT JOIN @RS_DANFE_LIB L ON
			A.CD_CTR_DANFE = L.CD_CTR AND
			L.TP_BLOQ = 8
	WHERE
		( ( VLR_IT_DANFE - VLR_IT_DESC_DANFE ) - ( VLR_IT_PED - VLR_IT_DESC_PED ) ) > @VLR_DIV AND
		L.CD_CTR IS NULL; --> QUE NAO ESTEJA LIBERADO..


/**********************************************************************************************/
--Implementar uma forma melhor
    DECLARE @NaoUtilizaControleDivergenciaCompleto VARCHAR(MAX);

    SET @NaoUtilizaControleDivergenciaCompleto = ISNULL((SELECT valor FROM prc_emp_config WHERE cd_chave ='NAO_USA_CONTROLE_DIVERGENCIA_TOTAL'),'');

    IF @NaoUtilizaControleDivergenciaCompleto <> ''
    BEGIN
		--BEGIN TRY
			DELETE FROM @RS_BLOQ WHERE TP_BLOQ IN (SELECT ID FROM DBO.UFD_PRM_IN_STRING(@NaoUtilizaControleDivergenciaCompleto))
		--END TRY
		--BEGIN CATCH
		--	PRINT 'ERRO AO CAPTURAR PARAMETRO DE EXCLUSAO'
		--END CATCH
    END
/**********************************************************************************************/

	RETURN          

END           